/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent;

import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.entity.ai.GoToEntityPositionGoal;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.ModDefinitions;
import net.smileycorp.hordes.common.hordeevent.capability.HordeWorldData;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeEvent;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeSpawn;

@Mod.EventBusSubscriber(modid="hordes")
public class HordeEventHandler {
    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof MobEntity) {
            event.addCapability(ModDefinitions.getResource("HordeSpawn"), (ICapabilityProvider)new IHordeSpawn.Provider());
        }
        if (entity instanceof PlayerEntity && !(entity instanceof FakePlayer)) {
            event.addCapability(ModDefinitions.getResource("HordeEvent"), (ICapabilityProvider)new IHordeEvent.Provider());
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        ServerWorld world;
        if (event.phase == TickEvent.Phase.START && (world = (server = ServerLifecycleHooks.getCurrentServer()).func_241755_D_()).func_82736_K().func_223586_b(GameRules.field_223607_j) | (Boolean)CommonConfigHandler.pauseEventServer.get() == false) {
            HordeWorldData data;
            int day = (int)Math.floor(world.func_72820_D() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue());
            if (day >= (data = HordeWorldData.getData(world)).getNextDay()) {
                data.setNextDay(world.field_73012_v.nextInt((Integer)CommonConfigHandler.hordeSpawnVariation.get() + 1) + (Integer)CommonConfigHandler.hordeSpawnDays.get() + data.getNextDay());
            }
            data.save();
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (event.phase == TickEvent.Phase.END && player != null && !(player instanceof FakePlayer)) {
            LazyOptional optional;
            World world = player.field_70170_p;
            if (!world.field_72995_K && (world.func_82736_K().func_223586_b(GameRules.field_223607_j) || !((Boolean)CommonConfigHandler.pauseEventServer.get()).booleanValue()) && (optional = player.getCapability(Hordes.HORDE_EVENT, null)).isPresent()) {
                IHordeEvent horde = (IHordeEvent)optional.resolve().get();
                int day = (int)Math.floor(world.func_72820_D() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue());
                int time = Math.round(world.func_72820_D() % (long)((Integer)CommonConfigHandler.dayLength.get()).intValue());
                if (horde != null && !horde.isActive(player) && time >= (Integer)CommonConfigHandler.hordeStartTime.get() && day >= horde.getNextDay() && (day != 0 || ((Boolean)CommonConfigHandler.spawnFirstDay.get()).booleanValue())) {
                    horde.tryStartEvent(player, (Integer)CommonConfigHandler.hordeSpawnDuration.get(), false);
                }
                if (horde.isActive(player)) {
                    horde.update(player);
                }
            }
        }
    }

    @SubscribeEvent
    public void tryDespawn(LivingSpawnEvent.AllowDespawn event) {
        LazyOptional optionalp;
        ServerPlayerEntity player;
        String uuid;
        IHordeSpawn cap;
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        LazyOptional optional = entity.getCapability(Hordes.HORDESPAWN, null);
        if (optional.isPresent() && (cap = (IHordeSpawn)optional.resolve().get()).isHordeSpawned() && DataUtils.isValidUUID((String)(uuid = cap.getPlayerUUID())) && (player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(UUID.fromString(uuid))) != null && (optionalp = player.getCapability(Hordes.HORDE_EVENT, null)).isPresent() && ((IHordeEvent)optionalp.resolve().get()).isActive(player)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof MobEntity) {
            LazyOptional optionalp;
            ServerPlayerEntity player;
            String uuid;
            IHordeSpawn cap;
            MobEntity entity = (MobEntity)event.getEntity();
            if (entity.field_70170_p.field_72995_K) {
                return;
            }
            LazyOptional optional = entity.getCapability(Hordes.HORDESPAWN, null);
            if (optional.isPresent() && (cap = (IHordeSpawn)optional.resolve().get()).isHordeSpawned() && DataUtils.isValidUUID((String)(uuid = cap.getPlayerUUID())) && (player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(UUID.fromString(uuid))) != null && (optionalp = player.getCapability(Hordes.HORDE_EVENT, null)).isPresent()) {
                ((IHordeEvent)optionalp.resolve().get()).removeEntity(entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void update(LivingEvent.LivingUpdateEvent event) {
        ServerPlayerEntity player;
        String uuid;
        IHordeSpawn cap;
        MobEntity entity;
        LazyOptional optional;
        World world = event.getEntity().field_70170_p;
        if (!world.field_72995_K && event.getEntity() instanceof MobEntity && world.func_234923_W_() == World.field_234918_g_ && event.getEntity().field_70173_aa % 5 == 0 && (optional = (entity = (MobEntity)event.getEntity()).getCapability(Hordes.HORDESPAWN, null)).isPresent() && (cap = (IHordeSpawn)optional.resolve().get()).isHordeSpawned() & !cap.isSynced() && DataUtils.isValidUUID((String)(uuid = cap.getPlayerUUID())) && (player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(UUID.fromString(uuid))) != null) {
            entity.field_70715_bh.func_220888_c().forEach(goal -> goal.func_75251_c());
            if (entity instanceof CreatureEntity) {
                entity.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)entity, new Class[0]));
            }
            entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal(entity, PlayerEntity.class, true));
            LazyOptional optionalp = player.getCapability(Hordes.HORDE_EVENT, null);
            if (optionalp.isPresent()) {
                ((IHordeEvent)optionalp.resolve().get()).registerEntity(entity);
                entity.field_70714_bg.func_75776_a(6, (Goal)new GoToEntityPositionGoal(entity, (Entity)player));
            }
            cap.setSynced();
        }
    }

    @SubscribeEvent
    public void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server;
        if (((Boolean)CommonConfigHandler.pauseEventServer.get()).booleanValue() && (server = ServerLifecycleHooks.getCurrentServer()).func_71233_x() == 0) {
            server.func_212370_w().forEach(world -> {
                if (world.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
                    ((GameRules.BooleanValue)world.func_82736_K().func_223585_a(GameRules.field_223607_j)).func_223570_a(false, server);
                }
            });
        }
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (((Boolean)CommonConfigHandler.pauseEventServer.get()).booleanValue()) {
            server.func_212370_w().forEach(world -> {
                if (!world.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
                    ((GameRules.BooleanValue)world.func_82736_K().func_223585_a(GameRules.field_223607_j)).func_223570_a(true, server);
                }
            });
        }
    }

    @SubscribeEvent
    public void trySleep(PlayerSleepInBedEvent event) {
        IHordeEvent horde;
        LazyOptional optional;
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (!((Boolean)CommonConfigHandler.canSleepDuringHorde.get()).booleanValue() && !world.field_72995_K && (optional = player.getCapability(Hordes.HORDE_EVENT, null)).isPresent() && ((horde = (IHordeEvent)optional.resolve().get()).isHordeDay(player) && world.func_230315_m_().func_241510_j_() & !world.func_72935_r() || horde.isActive(player))) {
            event.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.hordes.TrySleep"), true);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void playerClone(PlayerEvent.Clone event) {
        PlayerEntity player = event.getPlayer();
        PlayerEntity original = event.getOriginal();
        if (player != null && original != null & (!(player instanceof FakePlayer) && !(original instanceof FakePlayer))) {
            LazyOptional optionalp = player.getCapability(Hordes.HORDE_EVENT, null);
            LazyOptional optionalo = original.getCapability(Hordes.HORDE_EVENT, null);
            if (optionalp.isPresent() && optionalo.isPresent()) {
                IHordeEvent horde = (IHordeEvent)optionalp.resolve().get();
                horde.readFromNBT(((IHordeEvent)optionalo.resolve().get()).writeToNBT(new CompoundNBT()));
                horde.setPlayer(player);
            }
        }
    }
}

